/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.content.logistics.block.mechanicalArm;

import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderTag;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createcentralkitchen.content.contraptions.blazeStove.BlazeStoveBlockEntity;
import plus.dragons.createcentralkitchen.content.logistics.item.guide.cooking.CookingGuide;
import plus.dragons.createcentralkitchen.content.logistics.item.guide.cooking.CookingGuideItem;
import plus.dragons.createcentralkitchen.foundation.ponder.PonderArmInteractionPointType;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.registry.ModItems;

public class CookingPotPoint
extends ArmInteractionPoint {
    public static final int INPUT_SLOT_COUNT = 6;
    public static final int CONTAINER_SLOT = 7;
    public static final int OUTPUT_SLOT = 8;

    public CookingPotPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.m_82514_((Vec3i)this.pos, (double)0.625);
    }

    @Nullable
    protected IItemHandler getHandler() {
        if (!this.cachedHandler.isPresent()) {
            BlockEntity be = this.level.m_7702_(this.pos);
            if (!(be instanceof CookingPotBlockEntity)) {
                return null;
            }
            CookingPotBlockEntity cookingPot = (CookingPotBlockEntity)be;
            this.cachedHandler = LazyOptional.of(() -> ((CookingPotBlockEntity)cookingPot).getInventory());
        }
        return (IItemHandler)this.cachedHandler.orElse(null);
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos.m_7495_());
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return stack;
        }
        BlazeStoveBlockEntity blazeStove = (BlazeStoveBlockEntity)blockEntity;
        ItemStack guideStack = blazeStove.getGuide();
        if (!(guideStack.m_41720_() instanceof CookingGuideItem)) {
            return stack;
        }
        CookingGuide guide = CookingGuide.of(guideStack);
        if (guide.getResult().m_41619_()) {
            return stack;
        }
        IItemHandler inventory = this.getHandler();
        if (inventory == null) {
            return stack;
        }
        if (inventory.getStackInSlot(7).m_41619_() && guide.isContainer(stack)) {
            return inventory.insertItem(7, stack, simulate);
        }
        boolean[] neededSlots = new boolean[6];
        int neededSlotCount = 0;
        for (int slot = 0; slot < 6; ++slot) {
            if (!inventory.getStackInSlot(slot).m_41619_() || !guide.needIngredient(slot) || !guide.isIngredient(slot, stack)) continue;
            neededSlots[slot] = true;
            ++neededSlotCount;
        }
        if (neededSlotCount == 0) {
            return stack;
        }
        int countPerSlot = stack.m_41613_() / neededSlotCount;
        ItemStack ret = stack.m_41777_();
        for (int slot = 0; slot < 6; ++slot) {
            if (!neededSlots[slot]) continue;
            ItemStack inserted = ret.m_41620_(countPerSlot);
            inventory.insertItem(slot, inserted, simulate);
        }
        return ret;
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        ItemStack container;
        ItemStack ingredient;
        if (slot == 8) {
            return super.extract(slot, amount, simulate);
        }
        BlockEntity blockEntity = this.level.m_7702_(this.pos.m_7495_());
        if (!(blockEntity instanceof BlazeStoveBlockEntity)) {
            return ItemStack.f_41583_;
        }
        BlazeStoveBlockEntity blazeStove = (BlazeStoveBlockEntity)blockEntity;
        ItemStack guideStack = blazeStove.getGuide();
        if (!(guideStack.m_41720_() instanceof CookingGuideItem)) {
            return ItemStack.f_41583_;
        }
        CookingGuide guide = CookingGuide.of(guideStack);
        if (guide.getResult().m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler inventory = this.getHandler();
        if (inventory == null) {
            return ItemStack.f_41583_;
        }
        if (slot < 6 ? !(ingredient = inventory.getStackInSlot(slot)).m_41619_() && !guide.isIngredient(slot, ingredient) : slot == 7 && !(container = inventory.getStackInSlot(slot)).m_41619_() && !guide.isContainer(container)) {
            return inventory.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public static class Type
    extends PonderArmInteractionPointType {
        public Type(ResourceLocation id) {
            super(id);
        }

        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.m_7702_(pos) instanceof CookingPotBlockEntity && level.m_7702_(pos.m_7495_()) instanceof BlazeStoveBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CookingPotPoint(this, level, pos, state);
        }

        @Override
        public void addToPonderTag(Consumer<ItemLike> consumer) {
            PonderRegistry.TAGS.forTag(PonderTag.ARM_TARGETS).add((ItemLike)ModItems.COOKING_POT.get());
        }
    }
}

